<?php

use App\Http\Controllers\CartController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\CommonCntroller;
use App\Http\Controllers\HousingProjectController;
use App\Http\Controllers\SendPdfController;
use App\Http\Controllers\StreetLaneController;
use App\Http\Controllers\SubCategoryController;
use App\Http\Controllers\UnitBlockController;
use App\Http\Controllers\UnitSectorController;
use App\Http\Controllers\V1\AccountController;
use App\Http\Controllers\V1\InstallmentController;

use App\Http\Controllers\V1\Auth\CsPartyAuthController;
use App\Http\Controllers\V1\CityController;
use App\Http\Controllers\V1\CompanyController;
use App\Http\Controllers\V1\HousingChargesScheduleController;
use App\Http\Controllers\V1\HousingSaleTokenChillController;
use App\Http\Controllers\V1\HousingUnitPlotController;
use App\Http\Controllers\v1\LedgerDetailController;
use App\Http\Controllers\V1\LedgerMainController;

use App\Http\Controllers\PaymentController;
use App\Http\Controllers\SaleDeedMainController;
use App\Http\Controllers\V1\HousingSaleInstPayMain;
use App\Http\Controllers\V1\HousingUnitPremiumController;
use App\Http\Controllers\V1\ReportController;
use App\Http\Controllers\v1\TokenMainController;
use App\Http\Controllers\v1\TransactionController;
use Illuminate\Support\Facades\Route;
/*  
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API! test
|
*/
// Route::post('login', [UserController::class, 'login']);
//test

Route::post('add-subscription-message' ,[CommonCntroller::class,'addSubscription']);
Route::post('add-contact-message' ,[CommonCntroller::class,'addContactUsMessage']);


Route::get('blog/{id?}',[CompanyController::class,'blog']);
Route::middleware('auth:sanctum')->group(function () {

    Route::prefix('user')->controller(CsPartyAuthController::class)->group(function () {
        Route::post('/logout', 'logout');
        Route::put('change-password', 'changePassword');
        Route::post('update-profile', 'updateProfile');
    });

    Route::prefix('installments')->controller(InstallmentController::class)->group(function () {

        Route::get('plots-record', 'plotsRecord');
        Route::get('customer-plot-record', 'customerPlotsRecord');

        Route::get('plots-installment', 'plotInstallments');
    });

    Route::prefix('reports')->controller(ReportController::class)->group(function () {
        Route::get('dashboard', 'dashboardReport');
    });


    // Route::put('change-password','changePassword');


    Route::prefix('plots')->controller(HousingUnitPlotController::class)->group(function () {
        Route::get('plot-report', 'plotReport');
    });
});

// Route::prefix('housing-unit-plot')->middleware('auth:sanctum')->group(function () {
// });


Route::post('upload', [SendPdfController::class, 'upload']);
Route::post('uploadv1', [SendPdfController::class, 'uploadV1']);


Route::prefix('accounts')->controller(AccountController::class)->group(function () {
    Route::post('/store', 'store');
    Route::get('/index/{id?}', 'index');
    Route::get('/server-id', 'serverId');
    Route::put('/update', 'update');
    Route::put('change-updated-status', 'changeUpdatedStatus');
    Route::put('edit-by-sql', 'editbySql');
    Route::get('add-to-sql', 'addToSql');
    Route::put('update-account', 'updateAccount');
});


Route::prefix('ledger_main')->controller(LedgerMainController::class)->group(function () {
    Route::post('/store', 'store');
    Route::get('/index/{id?}', 'index');
    Route::get('/server-id', 'serverId');
    Route::put('/update', 'update');
    Route::put('change-updated-status', 'changeUpdatedStatus');
    Route::put('edit-by-sql', 'editbySql');
    Route::get('add-to-sql', 'addToSql');
});

Route::prefix('ledger_detail')->controller(LedgerDetailController::class)->group(function () {
    Route::post('/store', 'store');
    Route::get('/index/{id?}', 'index');
    Route::get('/server-id', 'serverId');
    Route::put('/update', 'update');
    Route::put('change-updated-status', 'changeUpdatedStatus');
    Route::put('edit-by-sql', 'editbySql');
    Route::get('add-to-sql', 'addToSql');
});


Route::prefix('categories')->controller(CategoryController::class)->group(function () {
    Route::post('/store', 'store');
    Route::get('/index/{id?}', 'index');
    Route::get('/server-id', 'serverId');
    Route::put('/update', 'update');
    Route::put('change-updated-status', 'changeUpdatedStatus');
    Route::put('edit-by-sql', 'editbySql');
    Route::get('list', 'list');
});


Route::prefix('sub_categories')->controller(SubCategoryController::class)->group(function () {
    Route::post('/store', 'store');
    Route::get('/index/{id?}', 'index');
    Route::get('/server-id', 'serverId');
    Route::put('/update', 'update');
    Route::put('change-updated-status', 'changeUpdatedStatus');
    Route::put('edit-by-sql', 'editbySql');
});


Route::prefix('unit_premiums')->controller(HousingUnitPremiumController::class)->group(function () {
    Route::post('/store', 'store');
    Route::get('/index/{id?}', 'index');
    Route::get('/server-id', 'serverId');
    Route::put('/update', 'update');
    Route::put('change-updated-status', 'changeUpdatedStatus');
    Route::put('edit-by-sql', 'editbySql');

    Route::get('premium-list', 'premiumList');
});


Route::prefix('street_lanes')->controller(StreetLaneController::class)->group(function () {
    Route::post('/store', 'store');
    Route::get('/index/{id?}', 'index');
    Route::get('/server-id', 'serverId');
    Route::put('/update', 'update');
    Route::put('change-updated-status', 'changeUpdatedStatus');
    Route::put('edit-by-sql', 'editbySql');
});


Route::prefix('unit_blocks')->controller(UnitBlockController::class)->group(function () {
    Route::post('/store', 'store');
    Route::get('/index/{id?}', 'index');
    Route::get('/server-id', 'serverId');
    Route::put('/update', 'update');
    Route::put('change-updated-status', 'changeUpdatedStatus');
    Route::put('edit-by-sql', 'editbySql');
});


Route::prefix('unit_sectors')->controller(UnitSectorController::class)->group(function () {
    Route::post('/store', 'store');
    Route::get('/index/{id?}', 'index');
    Route::get('/server-id', 'serverId');
    Route::put('/update', 'update');
    Route::put('change-updated-status', 'changeUpdatedStatus');
    Route::put('edit-by-sql', 'editbySql');
});


Route::prefix('housing-unit-plot')->controller(HousingUnitPlotController::class)->group(function () {
    Route::post('/store', 'store');
    Route::get('/index/{id?}', 'index');
    Route::get('/server-id', 'serverId');
    Route::put('/update', 'update');
    Route::put('/change-updated-status', 'changeUpdatedStatus');
    Route::put('/edit-by-sql', 'editBySql');
    Route::get('plot-list/{id?}', 'plotList');

    Route::get('min-max-values', 'mixMaxValues');
    Route::get('plot-by-name', 'plotByName');
    Route::get('compare-plot/{id?}', 'comparePlot');
    // Route::put('','changeStatusPlot');
    // Route::get('min-max-marla','mixMaxMarla');
});


Route::prefix('companies')->controller(CompanyController::class)->group(function () {
    Route::post('/store', 'store');
    Route::get('/index/{id?}', 'index');
    Route::get('/server-id', 'serverId');
    Route::put('/update', 'update');
    Route::put('change-updated-status', 'changeUpdatedStatus');
    Route::put('edit-by-sql', 'editbySql');
});


Route::prefix('cs-party')->controller(CsPartyAuthController::class)->group(function () {
    Route::post('/store', 'store');
    Route::get('/index/{id?}', 'index');
    Route::get('/server-id', 'serverId');
    Route::put('/update/{id}', 'update');
    Route::put('change-updated-status', 'changeUpdatedStatus');
    Route::post('/login', 'login');
    Route::post('/add-customer', 'addCustomer');
    Route::put('/edit-by-sql', 'editbySql');
    Route::post('send-otp', 'sendOpt');
    Route::put('change-phone-no', 'changePhoneNo');
    Route::put('verify-otp', 'verifyOtp');
    Route::get('add-to-sql', 'addToSql');
    Route::post('delete/{id}', 'delete');
    Route::post('token-data', 'tokenData');
    Route::get('registered', 'registered');
    Route::post('forget-password', 'ForgetPassword');
    Route::put('reset-password', 'ResetPassword');

    Route::get('fetch-tokens', 'fetchTokens');

});


Route::prefix('transactions')->controller(TransactionController::class)->group(function () {
    Route::get('fetch', 'fetchTransaction');
    Route::put('change-update-status', 'changeUpdatedStatus');
});


Route::prefix('project')->controller(HousingProjectController::class)->group(function () {
    Route::post('/store', 'store');
    Route::get('/index/{id?}', 'index');
    Route::get('/server-id', 'serverId');
    // Route::put('/update/{id}','update');
    Route::put('change-updated-status', 'changeUpdatedStatus');
    // Route::post('login','loginsss');
    Route::put('/edit-by-sql', 'editbySql');
    Route::get('/fetch/{id?}', 'fetch');
    Route::post('/edit', 'edit');

});


Route::prefix('city')->controller(CityController::class)->group(function () {
    Route::post('/store', 'store');
    Route::get('/index/{id?}', 'index');
    Route::get('/server-id', 'serverId');
    Route::put('/update', 'update');
    Route::put('change-updated-status', 'changeUpdatedStatus');
    Route::put('edit-by-sql', 'editbySql');
});


Route::prefix('housing-charges-schedule')->controller(HousingChargesScheduleController::class)->group(function () {
    Route::post('/store', 'store');
    Route::get('/index/{id?}', 'index');
    Route::get('/server-id', 'serverId');
    Route::put('/update', 'update');
    Route::put('change-updated-status', 'changeUpdatedStatus');
    Route::put('edit-by-sql', 'editbySql');
});


Route::prefix('housing_sale_token_chill')->controller(HousingSaleTokenChillController::class)->group(function () {
    Route::post('/store', 'store');
    Route::get('/index/{id?}', 'index');
    Route::get('/server-id', 'serverId');
    Route::put('/update', 'update');
    Route::put('change-updated-status', 'changeUpdatedStatus');
    Route::put('edit-by-sql', 'editbySql');
    Route::get('add-to-sql', 'addToSql');
});


Route::prefix('token-main')->controller(TokenMainController::class)->group(function () {
    Route::post('/store', 'store');
    Route::get('/index/{id?}', 'index');
    Route::get('/server-id', 'serverId');
    Route::put('/update', 'update');
    Route::put('change-updated-status', 'changeUpdatedStatus');
    Route::put('edit-by-sql', 'editbySql');
    Route::get('add-to-sql', 'addToSql');
});


Route::prefix('carts')->controller(CartController::class)->group(function () {
    Route::post('/add-to-cart', 'addToCart');
    Route::get('/fetch-cart', 'fetchCart');
    Route::put('/edit/{id}', 'edit');
    Route::delete('/delete-cart', 'deleteCart');
    Route::put('update-cart', 'updateCart');
});


Route::prefix('payments')->controller(PaymentController::class)->group(function () {
    Route::post('pay', 'processPayment');
    Route::post('currency', 'convertCurrency');
    Route::post('store', 'store');
    Route::put('delete/{id}', 'softDelete');
    Route::get('index', 'index');
    Route::get('show/{id}', 'show');
    Route::get('fetch', 'fetchPayment');
    Route::get('fetch-token-transactions', 'fetchTokenTransactions');
    Route::put('change-update-status', 'changeUpdatedStatus');
    Route::post('pay-installment', 'payInstallment');
    Route::get('fetch-installment', 'fetchInstallment');


}); // check


Route::prefix('sale-deed-main')
    ->controller(SaleDeedMainController::class)->group(function () {

        Route::get('server-record', 'serverRecord');
        Route::post('store', 'store');
        Route::put('edit-by-sql', 'editbySql');

});


Route::prefix('sale-deed-ins')
    ->controller(InstallmentController::class)->group(function () {

        Route::get('server-record', 'serverRecord');
        Route::post('store', 'store');
        Route::put('edit-by-sql', 'editbySql');

    });
    Route::prefix('sale-deed-inst-pay-main')
    ->controller(HousingSaleInstPayMain::class)->group(function () {

        Route::get('server-record', 'serverRecord');
        Route::post('store', 'store');
        Route::put('edit-by-sql', 'editbySql');

    });


//contributed by shahzad
Route::prefix('v1')->group(function () {


    Route::prefix('housing-unit-plot')
        ->controller(HousingUnitPlotController::class)->group(function () {

            Route::get('report', 'plotReportV1');
            Route::get('/index/{id?}', 'indexV1');
            Route::get('compare-plot/{id?}', 'comparePlotV1');

        });


    Route::prefix('payments')
        ->controller(PaymentController::class)->group(function () {

            Route::get('index', 'indexV1');
            Route::get('show/{id}', 'showV1');
            Route::get('fetch-token-transactions', 'fetchTokenTransactionsV1');

        });


    // Route::prefix('installments')
    //     ->controller(InstallmentController::class)->group(function () {

    //         Route::get('plots-record', 'plotsRecordV1');
    //         Route::get('plots-installment', 'plotInstallmentsV1');
    //         Route::get('customer-plot-record', 'customerPlotsRecordV1');

    //     });

});